-- simBoard.lua

addSearchResourcesPath( moduleDirectory .. "/configuration/" )
local keyArrow   = sasl.gl.loadImage("KeySet_gray10.png",  75,   0,  72, 144)
local keyButton1 = sasl.gl.loadImage("KeySet_gray10.png", 150, 107, 103,  68)
local keyButton2 = sasl.gl.loadImage("KeySet_gray10.png", 0, 0, 55, 38)
local Wheel      = sasl.gl.loadImage("KeySet_gray10.png", 224,   0,  32, 106)
local roboto2 = loadFont(getXPlanePath().."Resources/fonts/Roboto-Bold.ttf")
local noto2 = loadFont(getXPlanePath().."Resources/fonts/NotoSansCJK-SC-Regular.otf")
local white  = {1, 1, 1, 1}
local black	= {0, 0, 0, 1}
local gray_L = {0.9, 0.9, 0.9, 1}
local yellow = {1, 1, 0, 1}
Note8 = "方位   deg (  0 = North )"
Note9 = "Heading    ( 90 = East  )"

size = {1200, 75}

function draw()
	if get(simStage) == 0 then
		drawText(noto2  ,120,20,Note8         ,12,false,false,TEXT_ALIGN_LEFT,white)
		drawText(roboto2,120, 7,Note9         ,12,false,false,TEXT_ALIGN_LEFT,white)
		drawText(roboto2,257,8,get(headPsi),24,false,false,TEXT_ALIGN_LEFT,yellow)
		sasl.gl.drawTexture(Wheel,298, 2, 20, 30)
		-- 
		drawText(noto2  ,345,20,"目標高度     km",12,false,false,TEXT_ALIGN_LEFT,white)
		drawText(roboto2,345, 7,"Target height",12,false,false,TEXT_ALIGN_LEFT,white)
		drawText(roboto2,430, 8,get(targetH),24,false,false,TEXT_ALIGN_LEFT,yellow)
		sasl.gl.drawTexture(keyArrow,475, 2, 20, 30)
		-- 
		sasl.gl.drawTexture(keyButton1,5,2,90,30) -- "Liftoff" button

	elseif get(simStage)==1 or get(simStage)==2 then
		velo = math.floor(get(crrVelo))
		-- 
		drawText(noto2  ,115,20,"速度    m/s" ,12,false,false,TEXT_ALIGN_LEFT,white)
		drawText(roboto2,110,7,"Velocity"    ,12,false,false,TEXT_ALIGN_LEFT,white)
		drawText(roboto2,185,9,velo          ,20,false,false,TEXT_ALIGN_LEFT,yellow)
		-- 
		drawText(noto2  ,255,20,"高度   km"   ,12,false,false,TEXT_ALIGN_LEFT,white)
		drawText(roboto2,262,7," height "    ,12,false,false,TEXT_ALIGN_LEFT,white)
		drawText(roboto2,325,9,get(dispH)    ,20,false,false,TEXT_ALIGN_LEFT,yellow)
		-- 
		drawText(noto2  ,410,20,"時刻     sec",12,false,false,TEXT_ALIGN_LEFT,white)
		drawText(roboto2,417,7," Timer  "    ,12,false,false,TEXT_ALIGN_LEFT,white)
		drawText(roboto2,475,9,"T= "         ,20,false,false,TEXT_ALIGN_LEFT,yellow)
		drawText(roboto2,505,9,get(t3)       ,20,false,false,TEXT_ALIGN_LEFT,yellow)
		-- 
		drawText(noto2  ,565,20,"Lon   経度"  ,12,false,false,TEXT_ALIGN_LEFT,white)
		drawText(roboto2,630,19,get(curLon) ,14,false,false,TEXT_ALIGN_LEFT,yellow)
		drawText(noto2  ,565, 7,"Lat   緯度"  ,12,false,false,TEXT_ALIGN_LEFT,white)
		drawText(roboto2,630, 6,get(curLat) ,14,false,false,TEXT_ALIGN_LEFT,yellow)
		-- 
		drawText(noto2,820,14,get(Note1)     ,16,true ,false,TEXT_ALIGN_LEFT,white)
		-- 
		sasl.gl.drawTexture(keyButton2, 5, 2, 87, 30)   -- "Return" button
	
	elseif get(simStage) == 3 then                      -- When simStage = 2
		velo = math.floor(get(crrVelo))
		drawText(noto2  ,115,20,"速度    m/s" ,12,false,false,TEXT_ALIGN_LEFT,gray_L)
		drawText(roboto2,110, 7,"Velocity"   ,12,false,false,TEXT_ALIGN_LEFT,gray_L)
		drawText(roboto2,185, 9,velo         ,20,false,false,TEXT_ALIGN_LEFT,yellow)
		-- 
		drawText(noto2  ,255,20,"高度   km"   ,12,false,false,TEXT_ALIGN_LEFT,gray_L)
		drawText(roboto2,262, 7," height "   ,12,false,false,TEXT_ALIGN_LEFT,gray_L)
		drawText(roboto2,325, 9,get(dispH)   ,20,false,false,TEXT_ALIGN_LEFT,yellow)
		-- 
		drawText(noto2  ,410,20,"時刻     sec",12,false,false,TEXT_ALIGN_LEFT,gray_L)
		drawText(roboto2,417, 7," Timer  "   ,12,false,false,TEXT_ALIGN_LEFT,gray_L)
		drawText(roboto2,475, 9,"T= "        ,20,false,false,TEXT_ALIGN_LEFT,yellow)
		drawText(roboto2,505, 9,get(t3)      ,20,false,false,TEXT_ALIGN_LEFT,yellow)
		-- 
		drawText(noto2  ,565,20,"Lon   経度"  ,12,false,false,TEXT_ALIGN_LEFT,gray_L)
		drawText(roboto2,630,19,get(curLon)  ,14,false,false,TEXT_ALIGN_LEFT,yellow)
		drawText(noto2  ,565, 7,"Lat   緯度"  ,12,false,false,TEXT_ALIGN_LEFT,gray_L)
		drawText(roboto2,630, 6,get(curLat)  ,14,false,false,TEXT_ALIGN_LEFT,yellow)
		-- 
		drawText(noto2  ,820,14,get(Note1)   ,16,true ,false,TEXT_ALIGN_LEFT,gray_L)
		-- 
		sasl.gl.drawTexture(keyButton2, 5, 2, 87, 30) -- "Return" button
	end
end